#!/bin/bash -
#===============================================================================
#
#          FILE: insertLocalProperties.sh
#
#         USAGE: ./insertLocalProperties.sh
#
#   DESCRIPTION: Inserts local application properties into the database
#                at startup time.
#
#       OPTIONS: ---
#  REQUIREMENTS: ---
#          BUGS: ---
#         NOTES: ---
#        AUTHOR: EGBERT, BARRY
#  ORGANIZATION:
#       CREATED: 04/26/2017
#      REVISION:  1.0
#===============================================================================

# This logic ensure that the Oracle service is up and running before executing the update script.
output=$(echo "exit;" | sudo su - oracle -c "sqlplus system/MhvD4t4@ORCL 2>&1" | grep -c "Connected to")
while [ $output -ne 1 ]; do
	sleep 5s
	output=$(echo "exit;" | sudo su - oracle -c "system/MhvD4t4@ORCL 2>&1" | grep -c "Connected to")
done

# Insert the user properties.
sudo su - oracle -c "sqlplus system/MhvD4t4@ORCL @/vagrant/sql/mhvdata/mhvdata_props_local.sql >> /data/logs/mhvdata_props_local.log"

